-- new script file

local waveLake = {}
local mission = {}

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
		mission.enemy = Citadels.GetPlayer(1)
	
	  if not self.loaded then
		  self.active = false
		  self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
	  end      
    
    self.lakeWave:LinkToTarget("retHandler")
    self.wayPoint1 = Game:GetEntity("churchLarge"):GetPosition()
    self.wayPoint2 = Game:GetEntity("meadowCastle"):GetPosition()
    self.wayPoint3 = Game:GetEntity("outerCastle"):GetPosition()
  end
  
  if self.active then
    InitializeWave(self)
    AttackWave(self)
		self.lakeWave:TriggerAllTargets()
    self.active = false
  end  
end

function InitializeWave(self)
  waveLake['unit_L_archer_L2'] = self.baseCount * 0.25
  waveLake['unit_L_archer_L3'] = self.baseCount * 0.20
  waveLake['unit_L_fman_L3'] = self.baseCount * 0.25
  waveLake['unit_L_rider_L2'] = self.baseCount * 0.20
  waveLake['unit_L_catapult_L2'] = self.baseCount * 0.04
  waveLake['unit_L_ram_L1'] = self.baseCount * 0.04
end

function AttackWave(self)
  for prefab,ammount in pairs(waveLake) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint1)
  mission.enemy:AttackGroupAddWayPoints(self.wayPoint2)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(), 20)
end

function OnTrigger(self, source, target)
  if target == "attLake" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
		self.active = ar:Read()
		self.baseCount = ar:Read()
  elseif (ar:IsSaving()) then
		ar:Write(self.active)
		ar:Write(self.baseCount)
	end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("attLake")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("lakeWave")
end

